using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;
using Android.Database.Sqlite;
using Android.Util;

namespace iXTankenAndroid
{
    [Activity(Label = "iXTanken > Neu", Theme = "@android:style/Theme.Light")]
    public class AddActivity : Activity
    {
        private const int MENU_SAVE = 1;
        private const int MENU_CANCEL = 2;

        private AddNewViewModel viewModel;
        private AddNewMyAdapter myAdapter;

        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);
            
            //var tv = new TextView(this);
            //tv.Text = "Hallo Welt!";

            //SetContentView(tv);
            SetContentView(Resource.Layout.Add);

            viewModel = new AddNewViewModel();
            myAdapter = new AddNewMyAdapter(this, viewModel);
        }

        public override bool OnCreateOptionsMenu(IMenu menu)
        {
            base.OnCreateOptionsMenu(menu);

            IMenuItem saveItem = menu.Add(0,MENU_SAVE,0,Resource.String.AddMenuSave);
        	saveItem.SetShortcut('1', 's');
        	saveItem.SetIcon(Android.Resource.Drawable.IcMenuSave);

            IMenuItem cancelItem = menu.Add(0, MENU_CANCEL, 1, Resource.String.AddMenuCancel);
            cancelItem.SetShortcut('2', 'c');
            cancelItem.SetIcon(Android.Resource.Drawable.IcMenuDelete);

            return true;
        }

        protected override void OnResume()
        {
            base.OnResume();
            ActivityHelper.CurrentActiviy = this;
        }

        public override bool OnOptionsItemSelected(IMenuItem item)
        {
            base.OnOptionsItemSelected(item);

            switch (item.ItemId)
            {
                case MENU_CANCEL:
                    viewModel.RollbackDataAction(null);
                    break;
                case MENU_SAVE:
                    viewModel.CommitDataAction(null);                   
                    break;
            }
            return true;
        }
    }
}